#pragma once
#include "GMatrix.h"


//==================================================================
// GSolve Declaration
//==================================================================
/*! \class GSolve
* \brief Definition, construction, modification and operations to resolve a system
*/
class GSolve
{
private:
    //members-------------------------------------------------------
	GMatrix _b;		
	GMatrix _p;		
	GVector _r;		
	bool _isValid;
    int _lines, _columns;
/*!
*\fn void orthogonalize(const GMatrix& a, const GVector& m)
*\brief Rsolution de Ax=b en utilisant la factorisation QR (GRAM-SCHMIDT): A de rang complet
* On utilise l'inverse de R inversible
*
*\param a : matrice A de Ax=b
*\param m : vecteur b de Ax=b
*/
	void orthogonalize(const GMatrix& a, const GVector& m);
/*!
*\fn void orthogonalize2(const GMatrix& a, const GVector& m)
*\brief Rsolution de Ax=b en utilisant la factorisation QR (GRAM-SCHMIDT) : le rang de A est
* quelconque, on utilise le pseudo inverse de R non inversible
*
*\param a : matrice A de Ax=b
*\param m : vecteur b de Ax=b
*/
	void orthogonalize2(const GMatrix& a, const GVector& m);
/*!
*\fn void orthogonalizeM(const GMatrix& a, const GVector& m)
*\brief Rsolution de Ax=b en utilisant la factorisation QR (GRAM-SCHMIDT modifi) :A
*
*\param a : matrice A de Ax=b
*\param m : vecteur b de Ax=b
*/
	
	void orthogonalizeM(const GMatrix &a, const GVector &m);

/*!
*\fn void householder(const GMatrix& a, const GVector& m)
*\brief Rsolution de Ax=b en utilisant la factorisation QR (Householder)
*
*\param a : matrice A de Ax=b
*\param m : vecteur b de Ax=b
*/
	void householder(const GMatrix &a, const GVector &m);

/*!
*\fn void givens(const GMatrix& a, const GVector& m)
*\brief Rsolution de Ax=b en utilisant la factorisation QR (givens)
*
*\param a : matrice A de Ax=b
*\param m : vecteur b de Ax=b
*/
	void givens(const GMatrix &a, const GVector &m);

/*!
*\fn bool verify_rank(const GMatrix& a, int& rank, vector<int>& dependent_columns)
*\brief Vrifier si la matrice a est de rang complet
*
*\param a : matrice a
*\param rank : rang de a
*\param dependant_columns : les numros de colonnes dpendants des colonnes indpendantes
*\return boolen = true si a est de rang complet
*/
	bool verify_rank(const GMatrix& a, int& rank, vector<int>& dependent_columns);
public:
	//public methods------------------------------------------------
	GSolve(const GMatrix& a, const GVector& m,short method=1);
	GSolve(const GMatrix& a, const GVector& m, int nblines,short method=1);
	/*!
    *  \brief Destructor
    *
    *  Destroyer Class GSolve
    */
	virtual ~GSolve();
	bool isValid();
	GVector& result();


};



